/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2026 i-net software GmbH, Berlin, Germany.
**/
package viewer;

import java.awt.BorderLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.IOException;
import java.net.URISyntaxException;

import javax.swing.JDialog;
import javax.swing.JFrame;

import com.inet.report.EngineRenderData;
import com.inet.viewer.RenderData;
import com.inet.viewer.SwingReportViewer;

/**
 * This sample demonstrates how you can include the i-net Clear Reports viewer in a Java application, e.g. on a client.
 */
public class ViewerInApplication extends JFrame {

    private RenderData         renderConnection;                          // This is our main render data connection - the source of our raw report data coming from our report server

    private SwingReportViewer  viewer;                                    // Our top-level viewer object

    private java.awt.Button    preview         = new java.awt.Button();

    private java.awt.TextField reportFile      = new java.awt.TextField();

    private java.awt.Label     reportFileLabel = new java.awt.Label();

    private java.awt.Label     status          = new java.awt.Label();

    /**
     *
     */
    public ViewerInApplication() {
        super( "i-net Clear Reports Viewer in a Java application on the client" );
        getContentPane().setLayout( null );
        setBackground( java.awt.Color.lightGray );
        setSize( 479, 281 );
        setVisible( false );
        preview.setLabel( "Preview" );
        getContentPane().add( preview );
        preview.setBounds( 348, 24, 100, 48 );

        String reportLocation = "file:C:/sample.rpt";
        try {
            reportLocation = getClass().getResource( "../sample.rpt" ).toURI().toString();
        } catch( URISyntaxException e ) {
            // Nothing to do
        }

        reportFile.setText( reportLocation );
        getContentPane().add( reportFile );
        reportFile.setBounds( 108, 36, 168, 24 );
        reportFileLabel.setText( "Report File" );
        getContentPane().add( reportFileLabel );
        reportFileLabel.setBounds( 12, 36, 78, 17 );
        getContentPane().add( status );
        status.setBounds( 12, 252, 461, 24 );

        SymAction lSymAction = new SymAction();
        preview.addActionListener( lSymAction );
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener( aSymWindow );
    }

    /**
     * Main method of this sample
     * @param args arguments not used
     * @throws IOException in case of IO errors. Often the port is already in use.
     */
    public static void main( String[] args ) throws IOException {
        (new ViewerInApplication()).setVisible( true );
    }

    /**
     * Window Adapter
     */
    class SymWindow extends java.awt.event.WindowAdapter {
        /**
         * Terminates the application if the user close the window.
         * @param event Window Event
         */
        @Override
        public void windowClosing( java.awt.event.WindowEvent event ) {
            Object object = event.getSource();
            ((Window)object).dispose();
            if( object instanceof ViewerInApplication ) {
                System.exit( 0 );
            }
        }
    }

    /**
     * Action Listener
     */
    class SymAction implements java.awt.event.ActionListener {
        /**
         * Checks if Preview button was clicked.
         * @param event Action Event
         */
        @Override
        public void actionPerformed( java.awt.event.ActionEvent event ) {
            Object object = event.getSource();
            if( object == preview ) {
                previewActionPerformed( event );
            }
        }
    }

    /**
     * Displays report in the Java viewer if Preview button was clicked.
     * @param event Action Event
     */
    void previewActionPerformed( java.awt.event.ActionEvent event ) {
        try {
            // create a target window for the viewer
            JDialog window = new JDialog( this, "Report Viewer" );
            window.setSize( Toolkit.getDefaultToolkit().getScreenSize() );

            // to initialize we first create a top level ReportViewer:
            viewer = new SwingReportViewer();

            // then initialize the render data connection.
            renderConnection = new EngineRenderData( "report=" + reportFile.getText() );

            // addNewReportView causes a new report view to be created using the given connection as its data source, and then
            // for this newly created report to be added to the viewer.
            viewer.addNewReportView( renderConnection );

            // add the viewer to the target window
            window.getContentPane().add( BorderLayout.CENTER, viewer );

            // to enable the close icon of the window
            SymWindow aSymWindow = new SymWindow();
            window.addWindowListener( aSymWindow );

            window.setVisible( true );
        } catch( Throwable e ) {
            status.setText( e.toString() );
            e.printStackTrace();
        }
    }
}
